/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.result;

import filenet.vw.api.VWException;
import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWQueue;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWWorkObject;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.result.VWAdminCommon;
import filenet.vw.toolkit.admin.result.VWAdminConfirmDialog;
import filenet.vw.toolkit.admin.result.VWAdminConfirmYesNoCancelDialog;
import filenet.vw.toolkit.admin.result.VWAdminElementInLogTableModel;
import filenet.vw.toolkit.admin.result.VWAdminElementTableData;
import filenet.vw.toolkit.admin.result.VWAdminElementTableModel;
import filenet.vw.toolkit.admin.result.VWAdminErrorDataObj;
import filenet.vw.toolkit.admin.result.VWAdminErrorsDialog;
import filenet.vw.toolkit.admin.result.VWAdminResultPane;
import filenet.vw.toolkit.admin.result.VWAdminResultTableModelBase;
import filenet.vw.toolkit.admin.result.VWAdminWOInRosterTableModel;
import filenet.vw.toolkit.admin.result.VWAdminWOTableModel;
import filenet.vw.toolkit.admin.result.VWAdminWorkObjectTableData;
import filenet.vw.toolkit.admin.result.resources.VWResource;
import filenet.vw.toolkit.utils.VWOpenItem;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.table.VWTable;
import java.awt.Container;
import java.awt.Frame;
import java.util.Vector;
import javax.swing.JApplet;
import javax.swing.JOptionPane;
import javax.swing.ListSelectionModel;

public class VWAdminOpenItem {
    private boolean m_bCanceled = false;
    private boolean m_bSave = false;
    private boolean m_bUnlock = false;
    private boolean m_bLock = false;
    private Vector m_vErrors = new Vector();
    private VWAdminResultPane m_resultsPane;
    private VWTable m_resultsTable;
    private int[] m_selectedRows;
    private int[] m_selectedCols;
    private VWAdminResultTableModelBase m_tableModel;
    protected Vector m_wobsList = new Vector();
    private VWParticipant m_logonUser = null;
    private Container m_mainContainer = null;
    private Frame m_parentFrame = null;
    private JApplet m_parentApplet = null;
    private ListSelectionModel m_listSelectionModel = null;
    private VWOpenItem m_vwOpenItem = null;
    private int m_applicationType = -1;

    public VWAdminOpenItem(VWAdminResultPane resultsPane, int applicationType) {
        this.m_resultsPane = resultsPane;
        this.m_selectedRows = this.m_resultsPane.getSelectedRows();
        this.m_selectedCols = this.m_resultsPane.getSelectedCols();
        this.m_tableModel = this.m_resultsPane.getTableModel();
        this.m_resultsTable = this.m_resultsPane.getResultsTable();
        this.m_listSelectionModel = this.m_resultsTable.getSelectionModel();
        this.m_logonUser = this.m_resultsPane.getLogonUser();
        this.m_mainContainer = this.m_resultsPane.getMainContainer();
        this.m_parentFrame = this.m_resultsPane.getParentFrame();
        this.m_parentApplet = this.m_resultsPane.getParentApplet();
        this.m_applicationType = applicationType;
        if (this.m_logonUser == null) {
            JOptionPane.showMessageDialog(this.m_parentFrame, VWResource.s_undeterminedLogonUser, VWResource.s_openItemDialogTitle, 1, null);
            this.m_bCanceled = true;
            return;
        }
        int rowIndex = this.m_selectedRows[0];
        if (this.m_tableModel instanceof VWAdminWOTableModel) {
            VWAdminWorkObjectTableData woData = (VWAdminWorkObjectTableData)this.m_tableModel.getObjectAt(rowIndex);
            this.processWork(woData);
        } else if (this.m_tableModel instanceof VWAdminElementTableModel) {
            if (!(this.m_tableModel instanceof VWAdminElementInLogTableModel)) {
                VWAdminElementTableData woData = (VWAdminElementTableData)this.m_tableModel.getObjectAt(rowIndex);
                VWWorkObject wob = woData.getWob();
                this.processWork(wob);
            }
        } else {
            return;
        }
        this.removeReferences();
    }

    private void processWork(VWAdminWorkObjectTableData woData) {
        VWWorkObject wob = woData.getWob();
        if (wob == null) {
            JOptionPane.showMessageDialog(this.m_parentFrame, VWResource.s_openItemNoAccessRights, VWResource.s_openItemDialogTitle, 0);
            return;
        }
        if (!this.isOKToOpenItem(wob, this.m_applicationType)) {
            return;
        }
        this.processLockedStatus(woData);
        if (this.m_bCanceled) {
            return;
        }
        if (this.m_bLock) {
            this.doLock();
            if (this.m_vErrors.size() != 0) {
                VWAdminErrorsDialog dlg = new VWAdminErrorsDialog(this.m_parentFrame, VWResource.s_openItemDialogTitle, VWResource.s_lockErr, this.m_vErrors);
                dlg.setVisible(true);
                this.m_tableModel.refreshSelectedRows(this.m_selectedRows);
                return;
            }
        }
        if (this.m_bUnlock) {
            this.doUnlock();
            if (this.m_vErrors.size() != 0) {
                VWAdminErrorsDialog dlg = new VWAdminErrorsDialog(this.m_parentFrame, VWResource.s_openItemDialogTitle, VWResource.s_unlockErr, this.m_vErrors);
                dlg.setVisible(true);
                this.m_tableModel.refreshSelectedRows(this.m_selectedRows);
                return;
            }
        }
        this.m_tableModel.refreshSelectedRows(this.m_selectedRows);
        this.processOpenItem(wob, this.m_applicationType);
    }

    private void processWork(VWWorkObject wob) {
        if (wob == null) {
            JOptionPane.showMessageDialog(this.m_parentFrame, VWResource.s_openItemNoAccessRights, VWResource.s_openItemDialogTitle, 0);
            return;
        }
        if (!this.isOKToOpenItem(wob, this.m_applicationType)) {
            return;
        }
        this.processLockedStatus(wob);
        if (this.m_bCanceled) {
            return;
        }
        if (this.m_bLock) {
            this.doLock(wob);
            if (this.m_vErrors.size() != 0) {
                VWAdminErrorsDialog dlg = new VWAdminErrorsDialog(this.m_parentFrame, VWResource.s_openItemDialogTitle, VWResource.s_lockErr, this.m_vErrors);
                dlg.setVisible(true);
                this.m_tableModel.refreshSelectedRows(this.m_selectedRows);
                return;
            }
        }
        if (this.m_bUnlock) {
            this.doUnlock(wob);
            if (this.m_vErrors.size() != 0) {
                VWAdminErrorsDialog dlg = new VWAdminErrorsDialog(this.m_parentFrame, VWResource.s_openItemDialogTitle, VWResource.s_unlockErr, this.m_vErrors);
                dlg.setVisible(true);
                this.m_tableModel.refreshSelectedRows(this.m_selectedRows);
                return;
            }
        }
        this.m_tableModel.refreshSelectedRows(this.m_selectedRows);
        this.processOpenItem(wob, this.m_applicationType);
    }

    private boolean isOKToOpenItem(VWWorkObject wob, int applicationType) {
        boolean isOK = true;
        try {
            String queueName = wob.getCurrentQueueName();
            if (applicationType != 0 && applicationType == 1) {
                String exceptionStr = wob.getLastErrorNumber();
                if (exceptionStr != null && VWStringUtils.compare(exceptionStr, "0") != 0) {
                    return false;
                }
                if (wob.getIsTracker()) {
                    isOK = false;
                } else {
                    VWSession session = this.m_resultsPane.getSession();
                    VWQueue queue = session.getQueue(queueName);
                    if (queue.getQueueType() == 3 || queue.getIsConnectorQueue()) {
                        JOptionPane.showMessageDialog(this.m_resultsPane.getParentFrame(), VWResource.s_openItemCannotLaunchSP, VWResource.s_openItemDialogTitle, 0);
                        isOK = false;
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            isOK = false;
        }
        return isOK;
    }

    private void processOpenItem(VWWorkObject wob, int applicationType) {
        try {
            String queueName = wob.getCurrentQueueName();
            if (this.m_vwOpenItem == null) {
                this.m_vwOpenItem = new VWOpenItem(this.m_resultsPane.getSession(), this.m_mainContainer, this.m_parentApplet);
            }
            if (applicationType == 0) {
                this.m_vwOpenItem.openStatusTracker(queueName, wob.getWorkObjectNumber(), 2);
            } else if (applicationType == 1) {
                this.m_vwOpenItem.openStepProcessor(queueName, wob.getWorkObjectNumber(), wob.getStepName(), wob.fetchStepProcessorInfo());
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private int getLockedStatus(VWWorkObject wob) {
        if (this.m_logonUser == null) {
            return -1;
        }
        try {
            int lockedStatus = wob.fetchLockedStatus();
            if (lockedStatus == 2) {
                return 0;
            }
            if (lockedStatus == 0) {
                return 3;
            }
            VWParticipant lockedUser = wob.getLockedUserPx();
            if (lockedUser != null) {
                if (VWStringUtils.compareUsers(lockedUser.getParticipantName(), this.m_logonUser.getParticipantName())) {
                    return 1;
                }
                return 2;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return -1;
    }

    private void processLockedStatus(VWAdminWorkObjectTableData woData) {
        int lockStatus = woData.getLockedStatus();
        if (lockStatus == 3) {
            return;
        }
        if (lockStatus == 1) {
            this.m_wobsList.addElement(woData);
            VWAdminCommon.addChildrenToWobsList(woData.getChildren(), true, this.m_wobsList);
            if (VWAdminCommon.isAnyWorkModified(this.m_wobsList)) {
                VWAdminConfirmYesNoCancelDialog confirmDlg = new VWAdminConfirmYesNoCancelDialog(this.m_parentFrame, VWResource.s_openItemDialogTitle, VWResource.s_openItemLockByCurrentUserAndDirty, 0);
                confirmDlg.setVisible(true);
                if (confirmDlg.isCanceled()) {
                    this.m_bCanceled = true;
                    return;
                }
                this.m_bSave = confirmDlg.isYes();
            } else {
                VWAdminConfirmDialog confirmDlg = new VWAdminConfirmDialog(this.m_parentFrame, VWResource.s_openItemDialogTitle, VWResource.s_openItemLockByCurrentUser, 0);
                confirmDlg.setVisible(true);
                if (confirmDlg.isCanceled()) {
                    this.m_bCanceled = true;
                    return;
                }
            }
            this.m_bUnlock = true;
        } else if (lockStatus == 2) {
            this.m_wobsList.addElement(woData);
            VWAdminConfirmDialog confirmDlg = new VWAdminConfirmDialog(this.m_parentFrame, VWResource.s_openItemDialogTitle, VWResource.s_openItemLockByOthers, 0);
            confirmDlg.setVisible(true);
            if (confirmDlg.isCanceled()) {
                this.m_bCanceled = true;
                return;
            }
            this.m_bLock = true;
            this.m_bUnlock = true;
        } else {
            JOptionPane.showMessageDialog(this.m_parentFrame, VWResource.s_undeterminedLockUser, VWResource.s_openItemDialogTitle, 0);
            this.m_bCanceled = true;
            return;
        }
    }

    private void processLockedStatus(VWWorkObject wob) {
        int lockStatus = this.getLockedStatus(wob);
        if (lockStatus == 3) {
            return;
        }
        if (lockStatus == 1) {
            VWAdminConfirmDialog confirmDlg = new VWAdminConfirmDialog(this.m_parentFrame, VWResource.s_openItemDialogTitle, VWResource.s_openItemLockByCurrentUser, 0);
            confirmDlg.setVisible(true);
            if (confirmDlg.isCanceled()) {
                this.m_bCanceled = true;
                return;
            }
            this.m_bUnlock = true;
        } else if (lockStatus == 2) {
            VWAdminConfirmDialog confirmDlg = new VWAdminConfirmDialog(this.m_parentFrame, VWResource.s_openItemDialogTitle, VWResource.s_openItemLockByOthers, 0);
            confirmDlg.setVisible(true);
            if (confirmDlg.isCanceled()) {
                this.m_bCanceled = true;
                return;
            }
            this.m_bLock = true;
            this.m_bUnlock = true;
        } else {
            JOptionPane.showMessageDialog(this.m_parentFrame, VWResource.s_undeterminedLockUser, VWResource.s_openItemDialogTitle, 0);
            this.m_bCanceled = true;
            return;
        }
    }

    private void doLock() {
        VWWorkObject[] woArray = null;
        Vector<VWWorkObject> woVector = new Vector<VWWorkObject>();
        VWException[] arrayExceptions = null;
        if (this.m_vErrors != null) {
            this.m_vErrors.removeAllElements();
        }
        if (this.m_tableModel instanceof VWAdminWOInRosterTableModel) {
            for (int i = 0; i < this.m_wobsList.size(); ++i) {
                VWAdminWorkObjectTableData woData = (VWAdminWorkObjectTableData)this.m_wobsList.elementAt(i);
                if (woData.getLockedStatus() == 1) continue;
                VWWorkObject wob = woData.getWob();
                try {
                    wob.doLock(true);
                    wob.doRefresh(true, true);
                    woData.updateLockedInfo();
                    continue;
                }
                catch (Exception ex) {
                    VWAdminErrorDataObj errObj = new VWAdminErrorDataObj(wob, ex);
                    this.m_vErrors.addElement(errObj);
                    VWDebug.logException(ex);
                }
            }
        } else {
            int i;
            int i2;
            for (i2 = 0; i2 < this.m_wobsList.size(); ++i2) {
                VWAdminWorkObjectTableData woData = (VWAdminWorkObjectTableData)this.m_wobsList.elementAt(i2);
                int lockedStatus = woData.getLockedStatus();
                if (woData.getLockedStatus() == 1) continue;
                woVector.addElement(woData.getWob());
            }
            if (woVector.size() != 0) {
                woArray = new VWWorkObject[woVector.size()];
                for (i2 = 0; i2 < woVector.size(); ++i2) {
                    woArray[i2] = (VWWorkObject)woVector.elementAt(i2);
                }
                try {
                    VWWorkObject curWorkObject = woArray[0];
                    arrayExceptions = VWWorkObject.doLockMany(woArray, true);
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                }
            } else {
                return;
            }
            for (i = 0; i < woArray.length; ++i) {
                VWWorkObject wob = woArray[i];
                try {
                    if (arrayExceptions[i] == null) {
                        wob.doRefresh(true, true);
                        VWAdminWorkObjectTableData woData = VWAdminCommon.findWoData(wob, this.m_wobsList);
                        if (woData == null) continue;
                        woData.updateLockedInfo();
                        continue;
                    }
                    VWAdminErrorDataObj errObj = new VWAdminErrorDataObj(wob, arrayExceptions[i]);
                    this.m_vErrors.addElement(errObj);
                    VWDebug.logException(arrayExceptions[i]);
                    continue;
                }
                catch (Exception ex) {
                    VWAdminErrorDataObj errObj = new VWAdminErrorDataObj(wob, arrayExceptions[i]);
                    this.m_vErrors.addElement(errObj);
                    VWDebug.logException(ex);
                }
            }
            if (arrayExceptions != null) {
                for (i = 0; i < arrayExceptions.length; ++i) {
                    arrayExceptions[i] = null;
                }
            }
            if (woArray != null) {
                for (i = 0; i < woArray.length; ++i) {
                    woArray[i] = null;
                }
            }
            if (woVector != null) {
                woVector.removeAllElements();
            }
        }
    }

    private void doLock(VWWorkObject wob) {
        if (this.m_vErrors != null) {
            this.m_vErrors.removeAllElements();
        }
        if (this.m_bLock) {
            try {
                wob.doLock(true);
            }
            catch (Exception ex) {
                VWAdminErrorDataObj errObj = new VWAdminErrorDataObj(wob, ex);
                this.m_vErrors.addElement(errObj);
                VWDebug.logException(ex);
            }
        }
    }

    private void doUnlock() {
        boolean bDispatch = false;
        VWWorkObject[] woArray = null;
        Vector<VWWorkObject> woVector = new Vector<VWWorkObject>();
        VWException[] arrayExceptions = null;
        if (this.m_vErrors != null) {
            this.m_vErrors.removeAllElements();
        }
        if (this.m_tableModel instanceof VWAdminWOInRosterTableModel) {
            for (int i = 0; i < this.m_wobsList.size(); ++i) {
                VWAdminWorkObjectTableData woData = (VWAdminWorkObjectTableData)this.m_wobsList.elementAt(i);
                VWWorkObject wob = woData.getWob();
                try {
                    if (this.m_bUnlock) {
                        if (this.m_bSave) {
                            wob.doSave(true);
                        } else {
                            wob.doAbort();
                        }
                    }
                    wob.doRefresh(false, false);
                    woData.setDirty(false);
                    woData.updateLockedInfo();
                    continue;
                }
                catch (Exception ex) {
                    VWAdminErrorDataObj errObj = new VWAdminErrorDataObj(wob, ex);
                    this.m_vErrors.addElement(errObj);
                    VWDebug.logException(ex);
                }
            }
        } else {
            int i;
            int i2;
            for (i2 = 0; i2 < this.m_wobsList.size(); ++i2) {
                VWAdminWorkObjectTableData woData = (VWAdminWorkObjectTableData)this.m_wobsList.elementAt(i2);
                woVector.addElement(woData.getWob());
            }
            if (woVector.size() == 0) {
                return;
            }
            if (this.m_bUnlock) {
                woArray = new VWWorkObject[woVector.size()];
                for (i2 = 0; i2 < woVector.size(); ++i2) {
                    woArray[i2] = (VWWorkObject)woVector.elementAt(i2);
                }
                try {
                    VWWorkObject curWorkObject = woArray[0];
                    arrayExceptions = VWWorkObject.doUnlockMany(woArray, this.m_bSave, bDispatch);
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                }
            }
            for (i = 0; i < woArray.length; ++i) {
                VWWorkObject wob = woArray[i];
                try {
                    if (arrayExceptions[i] == null) {
                        wob.doRefresh(false, false);
                        VWAdminWorkObjectTableData woData = VWAdminCommon.findWoData(wob, this.m_wobsList);
                        if (woData == null) continue;
                        woData.setDirty(false);
                        woData.updateLockedInfo();
                        continue;
                    }
                    VWAdminErrorDataObj errObj = new VWAdminErrorDataObj(wob, (Exception)arrayExceptions[i]);
                    this.m_vErrors.addElement(errObj);
                    VWDebug.logException(arrayExceptions[i]);
                    continue;
                }
                catch (Exception ex) {
                    VWAdminErrorDataObj errObj = new VWAdminErrorDataObj(wob, (Exception)arrayExceptions[i]);
                    this.m_vErrors.addElement(errObj);
                    VWDebug.logException(ex);
                }
            }
            if (arrayExceptions != null) {
                for (i = 0; i < arrayExceptions.length; ++i) {
                    arrayExceptions[i] = null;
                }
            }
            if (woArray != null) {
                for (i = 0; i < woArray.length; ++i) {
                    woArray[i] = null;
                }
            }
            if (woVector != null) {
                woVector.removeAllElements();
            }
        }
    }

    private void doUnlock(VWWorkObject wob) {
        boolean bDispatch = false;
        VWException[] arrayExceptions = null;
        VWWorkObject[] woArray = null;
        if (this.m_vErrors != null) {
            this.m_vErrors.removeAllElements();
        }
        if (this.m_bUnlock) {
            woArray = new VWWorkObject[]{wob};
            try {
                arrayExceptions = VWWorkObject.doUnlockMany(woArray, this.m_bSave, bDispatch);
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
            if (arrayExceptions[0] != null) {
                VWAdminErrorDataObj errObj = new VWAdminErrorDataObj(wob, arrayExceptions[0]);
                this.m_vErrors.addElement(errObj);
                VWDebug.logException(arrayExceptions[0]);
            }
            if (arrayExceptions != null) {
                for (int i = 0; i < arrayExceptions.length; ++i) {
                    arrayExceptions[i] = null;
                }
            }
            if (woArray != null) {
                for (int i = 0; i < woArray.length; ++i) {
                    woArray[i] = null;
                }
            }
        }
    }

    private void buildWobsList(int[] rows) {
        try {
            for (int i = 0; i < rows.length; ++i) {
                VWAdminWorkObjectTableData woData = (VWAdminWorkObjectTableData)this.m_tableModel.getObjectAt(rows[i]);
                if (woData.getLockedStatus() != 1) continue;
                this.m_wobsList.addElement(woData);
                VWAdminCommon.addChildrenToWobsList(woData.getChildren(), true, this.m_wobsList);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void removeReferences() {
        if (this.m_wobsList != null) {
            this.m_wobsList.removeAllElements();
        }
        if (this.m_vErrors != null) {
            this.m_vErrors.removeAllElements();
        }
    }
}

